import pandas as pd  
import pickle
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  
  
# Identify categorical variables  
categorical_columns = credit_customers.select_dtypes(include=['object']).columns  
  
# Initialize an empty list to store nominal categorical columns  
nominal_categorical_columns = []  
  
# Iterate through the categorical columns and append them to the nominal_categorical_columns list  
for col in categorical_columns:  
    nominal_categorical_columns.append(col)  
  
# Suggest encoding methods  
print("Suggested encoding methods:")  
print("1. One-hot encoding for nominal categorical variables:")  
for col in nominal_categorical_columns:  
    print("   -", col)  
  
# Example code for one-hot encoding  
credit_customers_encoded = pd.get_dummies(credit_customers, columns=nominal_categorical_columns)  
print("\nData after one-hot encoding:\n", credit_customers_encoded.head()) 
pickle.dump(credit_customers_encoded,open("./ref_result/credit_customers_encoded.pkl","wb"))
